#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_DivisionDefinition : BaseTest 
	{
		private class MockDivDef : DivisionDefinition
		{
			public MockDivDef( DataRow dr ) : base( dr ) {}
		}

		private const string InvalidDivCode1 = "";
		private const string InvalidDivCode2 = "123456";
		private const string InvalidDivName = "";
		
		private DivisionDefinition _testDivDef;
		private MockDivDef _testDivDefFromDR; 

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_testDivDef = new DivisionDefinition( UnitTestConfig.TestDivisionCode, UnitTestConfig.TestDivisionName );
			_testDivDefFromDR = new MockDivDef( ConstructTestDivDefDataRow() );
		}

		[TearDown]
		protected void TearDown()
		{
			_testDivDef = null;
			_testDivDefFromDR = null;
		}

		[Test]public void Ctor_String_String_Pass()
		{
			Assert.IsNotNull( _testDivDef );
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_String_String_Fail_1()
		{
			new DivisionDefinition( null, UnitTestConfig.TestDivisionName );
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_String_String_Fail_2()
		{
			new DivisionDefinition( UnitTestConfig.TestDivisionCode, null );
		}

		[Test][ExpectedException(typeof(BusinessObjectException))]
		public void Ctor_String_String_Fail_3()
		{
			new DivisionDefinition( InvalidDivCode1, UnitTestConfig.TestDivisionName );
		}

		[Test][ExpectedException(typeof(BusinessObjectException))]
		public void Ctor_String_String_Fail_4()
		{
			new DivisionDefinition( InvalidDivCode2, UnitTestConfig.TestDivisionName );
		}

		[Test][ExpectedException(typeof(BusinessObjectException))]
		public void Ctor_String_String_Fail_5()
		{
			new DivisionDefinition( UnitTestConfig.TestDivisionCode, InvalidDivName );
		}

		[Test]public void Ctor_DataRow_Pass()
		{
			Assert.IsNotNull( _testDivDefFromDR );
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_DataRow_Fail_1()
		{
			new MockDivDef( null );
		}

		[Test][ExpectedException(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail_2()
		{
			new MockDivDef( new DataTable().NewRow() );
		}

		[Test]public void DivisionCode_Pass_1()
		{
			Assert.AreEqual( UnitTestConfig.TestDivisionCode.Trim().ToUpper(), _testDivDef.DivisionCode );
		}

		[Test]public void DivisionCode_Pass_2()
		{
			Assert.AreEqual( UnitTestConfig.TestDivisionCode.Trim().ToUpper(), _testDivDefFromDR.DivisionCode );
		}

		[Test][Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void DivisionCode_Fail() {}

		[Test]public void DivisionName_Pass_1()
		{
			Assert.AreEqual( UnitTestConfig.TestDivisionName, _testDivDef.DivisionName );
		}

		[Test]public void DivisionName_Pass_2()
		{
			Assert.AreEqual( UnitTestConfig.TestDivisionName, _testDivDefFromDR.DivisionName );
		}

		[Test][Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void DivisionName_Fail() {}

		[Test]public void GetDivisionDefListFromVistA_Pass_1()
		{
			VistALinkUnitTestHarness.RequireConnection();
			
			Assert.IsNotNull( DivisionDefinition.GetDivisionDefListFromVistA() );

			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]public void GetDivisionDefListFromVistA_Pass_2()
		{
			VistALinkUnitTestHarness.RequireConnection();
			
			Assert.IsTrue( DivisionDefinition.GetDivisionDefListFromVistA().Count > 0 );

			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test][ExpectedException(typeof(InvalidOperationException))]
		public void GetDivisionDefListFromVistA_Fail()
		{
			try
			{
				VistALinkUnitTestHarness.ForcedDisconnect();
			
				DivisionDefinition.GetDivisionDefListFromVistA();
			}
			catch(gov.va.med.vbecs.DAL.VistALink.Client.VistALinkClientRPCException)
			{
				throw new InvalidOperationException();
			}
		}

		[Test]public void GetDivisionDefTableFromVistA_Pass()
		{
			VistALinkUnitTestHarness.RequireConnection();
			
			Assert.IsTrue( DivisionDefinition.GetDivisionDefTableFromVistA().Rows.Count > 0 );

			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test][ExpectedException(typeof(InvalidOperationException))]
		public void GetDivisionDefTableFromVistA_Fail()
		{
			try
			{
				VistALinkUnitTestHarness.ForcedDisconnect();
			
				DivisionDefinition.GetDivisionDefTableFromVistA();

			}
			catch(gov.va.med.vbecs.DAL.VistALink.Client.VistALinkClientRPCException)
			{
				throw new InvalidOperationException();
			}
		}

		[Test]public void LoadDataRowFromThis_Pass_1()
		{
			DataRow _dr = ConstructTestDataTable().NewRow();
			_testDivDef.LoadDataRowFromThis( _dr );

			Assert.AreEqual( UnitTestConfig.TestDivisionCode.Trim().ToUpper(), (string)_dr[ TABLES.VamcDivision.DivisionCode ] );
		}

		[Test]public void LoadDataRowFromThis_Pass_2()
		{
			DataRow _dr = ConstructTestDataTable().NewRow();
			_testDivDef.LoadDataRowFromThis( _dr );

			Assert.AreEqual( UnitTestConfig.TestDivisionName, (string)_dr[ TABLES.VamcDivision.DivisionName ] );
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void LoadDataRowFromThis_Fail_1()
		{
			_testDivDef.LoadDataRowFromThis( null );
		}

		[Test][ExpectedException(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail_2()
		{
			_testDivDef.LoadDataRowFromThis( new DataTable().NewRow() );
		}

		[Test]
		public void GetAllDivisionsDefListFromVbecs_Pass()
		{
			Assert.IsTrue( BOL.DivisionDefinition.GetAllDivisionsDefListFromVbecs().Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetAllDivisionsDefListFromVbecs_Fail() {}

		[Test]
		public void GetActiveVbecsDivisionsDefList_Pass()
		{
			Assert.IsTrue( BOL.DivisionDefinition.GetActiveVbecsDivisionsDefList().Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetActiveVbecsDivisionsDefList_Fail() {}

		private static DataTable ConstructTestDataTable()
		{
			DataTable _dt = new DataTable();
			_dt.Columns.Add( TABLES.VamcDivision.DivisionCode, typeof(string) );
			_dt.Columns.Add( TABLES.VamcDivision.DivisionName, typeof(string) );

			return _dt;
		}

		private static DataRow ConstructTestDivDefDataRow()
		{

			DataRow _dr = ConstructTestDataTable().NewRow();
			_dr[ TABLES.VamcDivision.DivisionCode ] = UnitTestConfig.TestDivisionCode;
			_dr[ TABLES.VamcDivision.DivisionName ] = UnitTestConfig.TestDivisionName;

			return _dr;
		}
	}
}
#endif
